const url = URL.parse(window.location.href).hash.replace("#", "") + ".mia";

function bytes2u32(n) {
	var res = 0;
	console.log(n);
	var n = n;
	for (var i = 0; i <= 3; i++) {
		res += n[3 - i] * Math.pow(2, 8 * i);
	}
	console.log(res);
	return res;
}

function sleep(ms) {
	return new Promise((resolve) => setTimeout(resolve, ms));
}

function parseType(n) {
	switch (n) {
		case 1:
			return "image/png";
		case 2:
			return "image/jpeg";
		case 3:
			return "image/webp";
		case 4:
			return "image/avif";
		default:
			return "";
	}
}

function read(n, buf, pos) {
	return buf.slice(pos, pos + n);
}

/*function bytesToBase64(bytes) {
	const binString = Array.from(bytes, (byte) =>
		String.fromCodePoint(byte),
	).join("");
	return btoa(binString);
}

async function fetchMia(url) {
	try {
		const response = await fetch(url, { cache: "force-cache" });
		if (!response.ok) {
			throw new Error(`Response status: ${response.status}`);
		}

		const v = await response.bytes();
		var pos = 0;
		const n = read(1, v, pos)[0];
		console.log("Reading", n, "images");
		pos += 1;
		var l = [];
		for (i = 0; i < n; i++) {
			console.log(n, i);
			const t = read(1, v, pos)[0];
			pos += 1;
			const b = bytes2u64(read(8, v, pos));
			pos += 8;
			console.log("Type:", parseType(t), "bytes:", b);
			l.push({ content_type: parseType(t), length: b });
		}
		for (i = 0; i < n; i++) {
			const nbytes = l[i].length;
			console.log("Bytes:", nbytes);
			const img = read(nbytes, v, pos);
			pos += nbytes;
			const im = document.createElement("img");
			console.log("Img:", img.byteLength);
			im.src = "data:" + l[i].content_type + ";base64," + bytesToBase64(img);
			im.style = "width: 90%;";
			document.querySelector("body").appendChild(im);
		}
	} catch (e) {
		console.error(e);
	}
}*/

function bytesToBase64(bytes) {
	const binString = Array.from(bytes, (byte) =>
		String.fromCodePoint(byte),
	).join("");
	return btoa(binString);
}

async function fetchMia(url) {
	try {
		const response = await fetch(url, {
			/*cache: "force-cache"*/
		});
		if (!response.ok) {
			throw new Error(`Response status: ${response.status}`);
		}

		const reader = response.body.getReader();
		let buffer = new Uint8Array(0);
		let pos = 0;
		let numImages = null;
		let imageInfos = [];
		let currentImageIndex = 0;

		while (true) {
			const { done, value } = await reader.read();
			if (done) break;

			buffer = concatArrays(buffer, value);

			while (pos < buffer.length) {
				if (numImages === null) {
					if (buffer.length < 1) break;
					numImages = buffer[0];
					console.log("Reading", numImages, "images");
					pos = 1;
					continue;
				}

				if (imageInfos.length < numImages) {
					if (buffer.length - pos < 5) break; // We need at least 9 bytes for type and length
					const t = buffer[pos];
					const b = bytes2u32(buffer.slice(pos + 1, pos + 5));
					console.log("Type:", parseType(t), "bytes:", b);
					imageInfos.push({ type: t, length: b });
					pos += 9;
					continue;
				}

				if (currentImageIndex < numImages) {
					const info = imageInfos[currentImageIndex];
					if (buffer.length - pos < info.length) break; // Not enough data for the full image

					const img = buffer.slice(pos, pos + info.length);
					const im = document.createElement("img");
					im.src =
						"data:" + parseType(info.type) + ";base64," + bytesToBase64(img);
					im.style = "width: 90%; display:block; margin: 0 auto;";
					document.querySelector("body").appendChild(im);

					pos += info.length;
					currentImageIndex++;
					continue;
				}

				// If we've processed all images, we're done
				if (currentImageIndex === numImages) {
					return;
				}
			}

			buffer = buffer.slice(pos);
			pos = 0;
		}
	} catch (e) {
		console.error(e);
	}
}

function concatArrays(a, b) {
	const c = new Uint8Array(a.length + b.length);
	c.set(a);
	c.set(b, a.length);
	return c;
}

fetchMia(url);
